SET CMDSEP / 

DROP PROCEDURE FDQA_Set_Values
/

CREATE PROCEDURE FDQA_Set_Values(
  IN_BIGINT BIGINT, IN_INT INT, IN_SMALLINT SMALLINT, IN_DECIMAL DECIMAL(19,4), IN_MONEY MONEY,
  IN_FLOAT FLOAT, IN_SMALLFLOAT SMALLFLOAT, IN_DATE DATE, IN_DATETIME DATETIME YEAR TO FRACTION, 
  IN_BOOLEAN BOOLEAN, IN_CHAR CHAR(10), IN_NCHAR NCHAR(10), IN_VARCHAR VARCHAR(10), 
  IN_NVARCHAR NVARCHAR(10), IN_LVARCHAR LVARCHAR(10))
  INSERT INTO "FDQA_All_types"(TBIGINT, TINT, TSMALLINT, TDECIMAL, TMONEY, TFLOAT, TSMALLFLOAT, 
    TDATE, TDATETIME, TBOOLEAN, TCHAR, TNCHAR, TVARCHAR, TNVARCHAR, TLVARCHAR)
  VALUES(IN_BIGINT, IN_INT, IN_SMALLINT, IN_DECIMAL, IN_MONEY, IN_FLOAT, IN_SMALLFLOAT, 
    IN_DATE, IN_DATETIME, IN_BOOLEAN, IN_CHAR, IN_NCHAR, IN_VARCHAR, IN_NVARCHAR, IN_LVARCHAR);
END PROCEDURE;
/

DROP PROCEDURE FDQA_All_Values
/

CREATE PROCEDURE FDQA_All_Values(
  I_BIGINT BIGINT, I_INT INT, I_SMALLINT SMALLINT, I_DECIMAL DECIMAL(19,4), I_MONEY MONEY,
  I_FLOAT FLOAT, I_SMALLFLOAT SMALLFLOAT, I_DATE DATE, I_DATETIME DATETIME YEAR TO FRACTION, 
  I_BOOLEAN BOOLEAN, I_CHAR CHAR(10), I_NCHAR NCHAR(10), I_VARCHAR VARCHAR(10), 
  I_NVARCHAR NVARCHAR(10), I_LVARCHAR LVARCHAR(10),
  OUT O_BIGINT BIGINT, OUT O_INT INT, OUT O_SMALLINT SMALLINT, OUT O_DECIMAL DECIMAL(19,4), OUT O_MONEY MONEY,
  OUT O_FLOAT FLOAT, OUT O_SMALLFLOAT SMALLFLOAT, OUT O_DATE DATE, OUT O_DATETIME DATETIME YEAR TO FRACTION, 
  OUT O_BOOLEAN BOOLEAN, OUT O_CHAR CHAR(10), OUT O_NCHAR NCHAR(10), OUT O_VARCHAR VARCHAR(10), 
  OUT O_NVARCHAR NVARCHAR(10), OUT O_LVARCHAR LVARCHAR(10))

  LET O_BIGINT = I_BIGINT;
  LET O_INT = I_INT;
  LET O_SMALLINT = I_SMALLINT;
  LET O_DECIMAL = I_DECIMAL;
  LET O_MONEY = I_MONEY;
  LET O_FLOAT = I_FLOAT;
  LET O_SMALLFLOAT = I_SMALLFLOAT;
  LET O_DATE = I_DATE;
  LET O_DATETIME = I_DATETIME;
  LET O_BOOLEAN = I_BOOLEAN;
  LET O_CHAR = I_CHAR;
  LET O_NCHAR = I_NCHAR;
  LET O_VARCHAR = I_VARCHAR;
  LET O_NVARCHAR = I_NVARCHAR;
  LET O_LVARCHAR = I_LVARCHAR;
END PROCEDURE;
/

DROP PROCEDURE FDQA_Get_values
/

CREATE PROCEDURE FDQA_Get_values()
RETURNING BIGINT, INT, SMALLINT, DECIMAL(19,4), MONEY, FLOAT, SMALLFLOAT, DATE, 
  DATETIME YEAR TO FRACTION, BOOLEAN, CHAR(10), NCHAR(10), VARCHAR(10), 
  NVARCHAR(10), LVARCHAR(10);
DEFINE I_BIGINT BIGINT;
DEFINE I_INT INT;
DEFINE I_SMALLINT SMALLINT;
DEFINE I_DECIMAL DECIMAL(19,4);
DEFINE I_MONEY MONEY;
DEFINE I_FLOAT FLOAT;
DEFINE I_SMALLFLOAT SMALLFLOAT;
DEFINE I_DATE DATE;
DEFINE I_DATETIME DATETIME YEAR TO FRACTION;
DEFINE I_BOOLEAN BOOLEAN;
DEFINE I_CHAR CHAR(10);
DEFINE I_NCHAR NCHAR(10);
DEFINE I_VARCHAR VARCHAR(10);
DEFINE I_NVARCHAR NVARCHAR(10);
DEFINE I_LVARCHAR LVARCHAR(10);
  FOREACH SELECT TBIGINT, TINT, TSMALLINT, TDECIMAL, TMONEY, TFLOAT, TSMALLFLOAT, TDATE,
                 TDATETIME, TBOOLEAN, TCHAR, TNCHAR, TVARCHAR, TNVARCHAR, TLVARCHAR
          INTO   I_BIGINT, I_INT, I_SMALLINT, I_DECIMAL, I_MONEY, I_FLOAT, I_SMALLFLOAT, I_DATE,
                 I_DATETIME, I_BOOLEAN, I_CHAR, I_NCHAR, I_VARCHAR, I_NVARCHAR, I_LVARCHAR
          FROM "FDQA_All_types"
    RETURN I_BIGINT, I_INT, I_SMALLINT, I_DECIMAL, I_MONEY, I_FLOAT, I_SMALLFLOAT, I_DATE,
           I_DATETIME, I_BOOLEAN, I_CHAR, I_NCHAR, I_VARCHAR, I_NVARCHAR, I_LVARCHAR WITH RESUME;
  END FOREACH;
END PROCEDURE;
/

DROP PROCEDURE FDQA_TestBinding
/

CREATE PROCEDURE FDQA_TestBinding (
  p1 int, p2 varchar(10), out p3 int, out p4 varchar(10))

  LET p3 = p1 * 10;
  LET p4 = p2 || '**';
END PROCEDURE;
/
